<?php

namespace App\Http\Controllers\Admin;

use App\Models\InvoiceItem;
use App\Models\Invoice;
use App\Models\Item;
use Illuminate\Http\Request;

class InvoiceItemController extends Controller
{
    public function create(Invoice $invoice)
    {
        $items = Item::all();
        return view('invoice_items.create', compact('invoice', 'items'));
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'invoice_id' => 'required|exists:invoices,id',
            'item_code' => 'required|exists:items,code',
            'description' => 'required|string',
            'quantity' => 'required|numeric',
            'unit_price' => 'required|numeric',
            'duration' => 'required|integer',
            'duration_unit' => 'required|in:day,week,month',
            'line_total' => 'required|numeric',
            'tax' => 'required|numeric',
            'line_total_with_tax' => 'required|numeric',
        ]);

        InvoiceItem::create($validated);
        return back()->with('success', 'Item added to invoice.');
    }

    public function destroy(InvoiceItem $invoiceItem)
    {
        $invoiceItem->delete();
        return back()->with('success', 'Invoice item deleted.');
    }
}
